/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake.texture;

import com.mojang.blaze3d.platform.NativeImage;
import customskinloader.fake.itf.FakeInterfaceManager;
import customskinloader.fake.texture.FakeImage;
import java.io.InputStream;

public class FakeNativeImage
implements FakeImage {
    private NativeImage image;

    public FakeNativeImage(int width, int height) {
        this(new NativeImage(width, height, true));
    }

    public FakeNativeImage(NativeImage image) {
        this.image = image;
    }

    public NativeImage getImage() {
        return this.image;
    }

    @Override
    public FakeImage createImage(int width, int height) {
        return new FakeNativeImage(width, height);
    }

    @Override
    public FakeImage createImage(InputStream is) {
        return new FakeNativeImage(NativeImage.m_85058_((InputStream)is));
    }

    @Override
    public int getWidth() {
        return this.image.m_84982_();
    }

    @Override
    public int getHeight() {
        return this.image.m_85084_();
    }

    @Override
    public int getRGBA(int x, int y) {
        return FakeInterfaceManager.NativeImage_getPixel(this.image, x, y);
    }

    @Override
    public void setRGBA(int x, int y, int rgba) {
        FakeInterfaceManager.NativeImage_setPixel(this.image, x, y, rgba);
    }

    @Override
    public void copyImageData(FakeImage image) {
        if (!(image instanceof FakeNativeImage)) {
            return;
        }
        this.image.m_85054_(((FakeNativeImage)image).getImage());
    }

    @Override
    public void fillArea(int x0, int y0, int width, int height) {
        this.image.m_84997_(x0, y0, width, height, 0);
    }

    @Override
    public void copyArea(int x0, int y0, int dx, int dy, int width, int height, boolean reversex, boolean reversey) {
        this.image.m_85025_(x0, y0, dx, dy, width, height, reversex, reversey);
    }

    @Override
    public void close() {
    }
}

